$(document).ready(function() {
    $('#clearAllTasks').click(function(event) {
      event.preventDefault(); // 阻止链接默认行为
    
      // 发起 AJAX 请求
      $.ajax({
          url: '?delrenwu=yes', // 请求的 URL
          type: 'GET', // 请求类型，根据后端要求可能是 'POST'
          success: function(response) {
              // 处理成功响应
              if (response.success) {
                  layer.alert('清空任务成功: ' + response.msg, {icon: 6});
              } else {
                  layer.alert('清空任务失败: ' + response.msg, {icon: 5});
              }
          },
          error: function(xhr, status, error) {
              // 处理错误
              layer.alert('请求错误: ' + error, {icon: 5});
          }
      });
    });
    });

$(document).ready(function() {
    $('#updateAnnouncement').click(function() {
        // 获取输入的标题和内容
        var title = $('#announcementTitle').val();
        var content = $('#announcementContent').val();

        // 发送 AJAX 请求
        $.ajax({
            url: '?biaoti=' + encodeURIComponent(title) + '&neirong=' + encodeURIComponent(content),
            type: 'GET', // 或者 'POST', 根据服务器端要求决定
            success: function(response) {
                // 假设服务器返回的响应包含一个 'msg' 字段
                if(response.success) {
                    layer.alert(response.msg, {icon: 6}); // 显示成功消息
                } else {
                    layer.alert('更新失败: ' + response.msg, {icon: 5}); // 显示错误消息
                }
            },
            error: function(xhr, status, error) {
                layer.alert('请求失败: ' + error, {icon: 5});
            }
        });
    });
});



$(document).ready(function() {
$('#getScreenshot').click(function(event) {
  event.preventDefault(); // 阻止默认行为

  $.ajax({
      url: '?png=yes', // 根据实际的 API 路径修改
      type: 'GET',
      success: function(response) {
          if (response.success && response.msg) {
              var imageUrl = "/cache/" + response.msg; // 根据需要更新此路径

              // 创建一个新的 Image 对象
              var img = new Image();
              img.onload = function() {
                  // 图片加载完成后显示弹出层
                  layer.open({
                      type: 1, // 页面层
                      title: '实时截图', // 弹出层标题
                      area: [(img.width / 2) + 'px', (img.height / 2) + 'px'], // 使用图片的实际宽高的一半作为弹出层尺寸
                      content: '<div style="text-align: center;"><img src="' + imageUrl + '" style="max-width: 100%; max-height: 100%;"></div>', // 包含图像的内容
                      shade: 0.6, // 背景变暗
                      shadeClose: true, // 允许点击背景关闭
                  });
              };
              img.src = imageUrl; // 设置图片源，触发加载
          } else {
              alert('无法获取截图: ' + response.msg); // 处理错误或不成功的操作
          }
      },
      error: function(xhr, status, error) {
          alert('请求截图失败: ' + error); // 处理 AJAX 错误
      }
  });
});
});


$(document).ready(function() {
$('#restartMall').click(function(event) {
  event.preventDefault(); // 阻止链接默认行为

  // 发起 AJAX 请求
  $.ajax({
      url: '?restart=yes', // 请求的 URL
      type: 'GET', // 请求类型，根据后端要求可能是 'POST'
      success: function(response) {
          // 处理成功响应
          if (response.success) {
              layer.alert('重启成功: ' + response.msg, {icon: 6});
          } else {
              layer.alert('重启失败: ' + response.msg, {icon: 5});
          }
      },
      error: function(xhr, status, error) {
          // 处理错误
          layer.alert('请求错误: ' + error, {icon: 5});
      }
  });
});
});

$(document).ready(function() {
// 绑定点击事件到#pauseDetection元素
$('#pauseDetection').click(function(event) {
  // 阻止链接的默认行为
  event.preventDefault();

  // 发起 AJAX 请求
  $.ajax({
      url: '?kaiguan=yes', // 请求的URL，根据实际情况修改
      type: 'GET', // 请求类型
      success: function(response) {
          // 成功获得响应后的处理逻辑
          if (response.success) {
              // 如果操作成功，显示成功的消息
              layer.alert(response.msg, {icon: 6});
          } else {
              // 如果操作失败，显示失败的消息
              layer.alert(response.msg, {icon: 5});
          }
      },
      error: function(xhr, status, error) {
          // 请求失败时的处理逻辑
          layer.alert('Error: ' + error, {icon: 5});
      }
  });
});
});

function sendUnlockNotification(elem) {
    var steamid = elem.getAttribute('data-steamid'); // 获取steamid
    // 弹出确认框
    layer.confirm('确定要赠送开锁通知吗？赠送天数以您设置好的参数为准！', {
        title: '确认操作',
        btn: ['确认', '取消'] // 按钮
    }, function(index) {
        // 用户点击“确认”后的处理
        $.ajax({
            url: '/Players.html', // 修改为你的实际处理URL
            type: 'POST',
            data: {
                zengsong: 'yes',
                steam: steamid
            },
            success: function(response) {
                layer.close(index); // 关闭confirm框
                if(response.success) {
                    layer.msg('赠送开锁通知成功: ' + response.msg);
                } else {
                    layer.msg('操作失败: ' + response.msg);
                }
            },
            error: function(xhr) {
                layer.msg('请求失败: ' + xhr.statusText);
            }
        });
    }, function(index) {
        // 用户点击“取消”后的处理
        layer.close(index);
    });
}



layui.use(['layer', 'form'], function(){
    var layer = layui.layer;
    var form = layui.form;

    window.adjustTokens = function(elem) {
        var steamid = elem.getAttribute('data-steamid'); // 获取steamid
        var contentHtml = document.getElementById('tokenFormTemplate').innerHTML; // 加载HTML模板

        // 创建弹窗
        var index = layer.open({
            type: 1,
            area: ['500px', '300px'],
            title: '调整代币数量',
            content: contentHtml,
            success: function(layero, index){
                form.render(); // 重新渲染表单
                form.on('submit(saveTokens)', function(data){
                    var formData = data.field; // 获取表单数据
                    var url = `/Players.html`; // API路径
                    // 发起Ajax请求
                    $.ajax({
                        url: url,
                        type: 'POST',
                        contentType: 'application/json', // 发送数据类型
                        data: JSON.stringify({
                            zengjia: formData.zengjia,
                            shuliang: formData.shuliang,
                            steam: steamid
                        }),
                        success: function(response) {
                            layer.close(index); // 关闭当前弹窗
                            if(response.success) {
                                layer.msg('操作成功: ' + response.msg); // 显示服务器返回的成功消息
                            } else {
                                layer.msg('操作失败: ' + response.msg); // 显示服务器返回的失败消息
                            }
                        },
                        error: function(xhr) {
                            layer.close(index); // 关闭当前弹窗
                            layer.msg('请求错误: ' + xhr.statusText); // 显示请求错误消息
                        }
                    });
                    return false; // 防止默认表单提交
                });
            }
        });
    };
});




window.changeMemberLevel = function(elem) {
    var steamid = elem.getAttribute('data-steamid'); // 获取steamid
    layer.open({
        type: 1,
        title: '修改会员等级',
        area: ['400px', '300px'], // 设置弹出框宽高
        content: `
            <div style="padding: 20px; font-family: Arial, sans-serif;">
                <div class="layui-form-item">
                    <label class="layui-form-label">新的会员等级</label>
                    <div class="layui-input-block">
                        <input type="text" id="newLevel" placeholder="请输入新的会员等级" class="layui-input" style="border: 1px solid #ccc; border-radius: 4px; padding: 10px;">
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">赠送天数</label>
                    <div class="layui-input-block">
                        <input type="number" id="giftDays" placeholder="请输入赠送天数" class="layui-input" style="border: 1px solid #ccc; border-radius: 4px; padding: 10px;">
                    </div>
                </div>
            </div>
        `,
        btn: ['确认', '取消'],
        yes: function(index, layero) {
            var newLevel = document.getElementById('newLevel').value; // 获取新的会员等级
            var giftDays = document.getElementById('giftDays').value; // 获取赠送天数

            $.ajax({
                url: '/Players.html', // 后端处理API的URL
                type: 'POST',
                data: {
                    huiyuan: newLevel,
                    steam: steamid,
                    days: giftDays // 传递赠送天数
                },
                success: function(response) {
                    if (response.success) {
                        layer.msg('操作成功: ' + response.msg); // 显示成功消息
                    } else {
                        layer.msg('操作失败: ' + response.msg); // 显示失败消息
                    }
                },
                error: function(xhr, status, error) {
                    layer.msg('请求错误: ' + error); // 显示请求错误消息
                }
            });
            layer.close(index); // 关闭弹出框
        }
    });
};



      
      function searchRedirect() {
          var searchValue = document.querySelector('input[name="search"]').value;
          window.location.href = '?sousuo=' + encodeURIComponent(searchValue);
      }

      function deletePlayerInfo(elem) {
        var steamid = elem.getAttribute('data-steamid'); // 获取steamid
        // 弹出确认框
        layer.confirm('确定要删除这位玩家的信息吗？', {
            title: '确认删除',
            btn: ['确认', '取消'] // 按钮
        }, function(index) {
            // 用户点击“确认”后的处理
            $.ajax({
                url: '/Players.html', // 修改为你的实际处理URL
                type: 'POST',
                data: {
                    delete: 'yes',
                    steam: steamid
                },
                success: function(response) {
                    layer.close(index); // 关闭confirm框
                    if(response.success) {
                        layer.msg('删除玩家信息成功: ' + response.msg);
                    } else {
                        layer.msg('操作失败: ' + response.msg);
                    }
                },
                error: function(xhr) {
                    layer.msg('请求失败: ' + xhr.statusText);
                }
            });
        }, function(index) {
            // 用户点击“取消”后的处理
            layer.close(index);
        });
    }
    document.addEventListener("DOMContentLoaded", function() {
        function getCurrentPage() {
            var urlParams = new URLSearchParams(window.location.search);
            return parseInt(urlParams.get('pag') || '1', 10); // 默认为第1页
        }
    
        function setupPagination() {
            var currentPage = getCurrentPage();
            var prevPage = currentPage > 1 ? currentPage - 1 : 1; // 上一页，最小为1
            var nextPage = currentPage + 1; // 假设总是有下一页
    
            var prevLink = '<a href="/Players.html?pag=' + prevPage + '" class="up">上一页</a>';
            var nextLink = '<a href="/Players.html?pag=' + nextPage + '" class="up">下一页</a>';
    
            var paginationHTML = '';
            if (currentPage > 1) {
                paginationHTML += prevLink; // 只有当当前页大于1时，才显示“上一页”
            }
            paginationHTML += nextLink; // 总是显示“下一页”
    
            document.querySelector('.divid-a').innerHTML = paginationHTML;
        }
    
        setupPagination();
    });    

    layui.use(['layer', 'form'], function() {
        var layer = layui.layer;
        var form = layui.form;
    
        // 监听全体加减代币按钮点击事件
        document.getElementById('adjustAllTokens').addEventListener('click', function() {
            adjustTokens(false); // 全体操作
        });
    
        // 监听在线加减代币按钮点击事件
        document.getElementById('adjustOnlineTokens').addEventListener('click', function() {
            adjustTokens(true); // 在线操作
        });
    
        function adjustTokens(isOnline) {
            var amountInput = document.querySelector('.form_3[type="text1"]'); // 获取数量输入框
            var actionSelect = document.querySelector('.form_3.dance'); // 获取操作选择下拉菜单
            var action = actionSelect.value; // 读取选中的操作（增加或减少）
            var amount = parseInt(amountInput.value, 10); // 转换输入的数量为整数
    
            // 验证是否选择了操作和输入了有效的数量
            if (action === "" || action === "请选择增加或减少") {
                layer.msg('请选择增加或减少');
                return;
            }
            if (isNaN(amount) || amount <= 0) {
                layer.msg('请输入有效的数量');
                return;
            }
    
            // 确认操作对话框
            layer.confirm(`您确定要${action} ${amount} 商城币吗？`, {
                btn: ['确认', '取消']
            }, function(index) {
                layer.close(index);
                // 构建请求URL和数据
                var onlineParam = isOnline ? 'yes' : 'no';
                var actionParam = action === "增加" ? 'true' : 'false';
                var url = `/Players.html?online=${onlineParam}&zengjias=${actionParam}&shuliang=${amount}`;
    
                // 发起Ajax请求
                $.ajax({
                    url: url,
                    type: 'POST',
                    success: function(response) {
                        if(response.success) {
                            layer.msg('操作成功: ' + response.msg);
                        } else {
                            layer.msg('操作失败: ' + response.msg);
                        }
                    },
                    error: function(xhr) {
                        layer.msg('请求失败，请检查网络设置');
                    }
                });
            });
        }
    });
    
    document.addEventListener('DOMContentLoaded', function() {
        var steamInput = document.querySelector('.form_3[type="text2"]');
    
        // 绑定授权管理员权限事件
        document.getElementById('grantAdmin').addEventListener('click', function() {
            sendAdminRequest('yes');
        });
    
        // 绑定取消管理员权限事件
        document.getElementById('revokeAdmin').addEventListener('click', function() {
            sendAdminRequest('no');
        });
    
        function sendAdminRequest(adminStatus) {
        var steamId = steamInput.value;
        if (steamId) {
            var url = `/Players.html?admin=${adminStatus}&steam=${encodeURIComponent(steamId)}`;
    
            $.ajax({
                url: url,
                type: 'GET', // 或者 'POST', 取决于你的服务器API
                dataType: 'json', // 确保指定返回数据为JSON格式
                success: function(response) {
                    // 由于预期服务器返回JSON对象，直接使用response.msg
                    layer.msg(response.msg);
                },
                error: function(xhr, status, error) {
                    // 你可以根据需要进一步处理错误
                    var errorMsg = xhr.responseJSON && xhr.responseJSON.msg ? xhr.responseJSON.msg : '请求失败: ' + error;
                    layer.msg(errorMsg);
                }
            });
        } else {
            layer.msg('请先填写玩家STEAMID');
        }
    }
    
    });
    